##Process score
function astro_game:game/process_score
function astro_game:lobby/computer/update_scores

##Set running state to false
scoreboard players set running astro_game.persistent 0

##Disable obstacles
scoreboard players set enabled astro_game.obstacles 0

##Clear obstacles and projectiles
function astro_game:game/clean

##Spawn egg if needed
execute positioned 27.0 47.15 66 if score collected_egg astro_game.obstacles matches 1.. run function astro_game:game/aliens/egg/spawn_egg

##Handle teleportation to base
execute if score collected_egg astro_game.obstacles matches 1.. run tp @a[tag=controller] 27.0 48.25 61.5 0 15
execute unless score collected_egg astro_game.obstacles matches 1.. run tp @a[tag=controller] 27.0 51.0 36.0 180 -5
execute as @a[tag=!white_suit,tag=!black_suit,tag=!orange_suit] run tp @s 27 48 66 0 0

##Clear speed effect
effect clear @a minecraft:speed

##Remove controller tag
tag @a remove controller

##Remove game_viewer tag
tag @a remove game_viewer

##Stop all sounds for the player
stopsound @a master

##Set in-game monitor
execute if score preset astro_game.persistent matches 0 as @e[tag=monitor] run data modify entity @s item.components."minecraft:custom_model_data" set value {floats:[107]}
execute if score preset astro_game.persistent matches 1 as @e[tag=monitor] run data modify entity @s item.components."minecraft:custom_model_data" set value {floats:[108]}
execute if score preset astro_game.persistent matches 2 as @e[tag=monitor] run data modify entity @s item.components."minecraft:custom_model_data" set value {floats:[109]}
execute if score preset astro_game.persistent matches 3 as @e[tag=monitor] run data modify entity @s item.components."minecraft:custom_model_data" set value {floats:[110]}

data modify entity @e[tag=buttons,limit=1] item.components."minecraft:custom_model_data" set value {floats:[30]}

##End music
function astro_game:ambience/set_lobby_bgm